﻿/*
PROPERTIES:
	selection			read-write
	selectable		read-write
	
EVENTS:
	onSelection
	onSelectable
	
*/



// This adds select capabilities
_this = this;
select = {};

// store component settings
select.initSelection = _this.selection;
select.initSelectable = _this.selectable;

// OBJECTS
select.start = {x:0, y:0};
select.end = {x:0, y:0};

// PROPERTIES
// // selection
select._selection = null;
_this.getSelection = function(){
	return select._selection;
}// get()
_this.setSelection = function( newValue, doEvent ){
	if(newValue)
	{// if:  selection is specified
		select._selection = newValue;
		// remove map-made selection image
		_this.selectionImage.removeMovieClip();
		// event: selection
		if(doEvent != false){
			_this.dispatchEvent({type:"onSelection"} );
			_this.onSelection();
		}
	}// if:  selection is specified
}// set()
_this.addProperty( "selection", _this.getSelection, _this.setSelection );



// // selectable
select._selectable = false;
_this.getSelectable = function(){
	return select._selectable;
}// get()
_this.setSelectable = function( newValue, doEvent ){
	if(newValue != select._selectable)
	{// if:  selectable changes
		select._selectable = newValue;
		// event
		if(doEvent != false){
			_this.dispatchEvent({type:"onSelectable"} );
			_this.onSelectable();
		}
	}// if:  selectable changes
}// set()
_this.addProperty( "selectable", _this.getSelectable, _this.setSelectable );





// ______________________________________________________________________________
// PROGRAM

// readPosition
select.readPosition = function()
{
	// get tile positions
	var xTile = Math.floor(_this._xmouse/16);
	var yTile = Math.floor(_this._ymouse/16);
	// enforce min
	xTile = (xTile<0) ? 0 : xTile;
	yTile = (yTile<0) ? 0 : yTile;
	// enforce max
	var xMax = _this._mapData.width-1;
	var yMax = _this._mapData.height-1;
	xTile = (xTile>xMax) ? xMax : xTile;
	yTile = (yTile>yMax) ? yMax : yTile;
	// report the results
	return {x:xTile, y:yTile};
}// readPosition()



// updateSelectionImage
select.updateSelectionImage = function( x1, y1, x2, y2 )
{
	// swap coords if neccessary
	if(x1 > x2){
		var xx1 = x1;
		x1 = x2;
		x2 = xx1;
	}// swap x
	if(y1 > y2){
		var yy1 = y1;
		y1 = y2;
		y2 = yy1;
	}// swap y
	
	// position
	select.selectionImage.x = x1 *16;
	select.selectionImage.y = y1 *16;
	
	// size
	var pixWidth = (x2 - x1 +1) *16;
	var pixHeight = (y2 - y1 +1) *16;
	select.selectionImage.width = pixWidth;
	select.selectionImage.height = pixHeight;
}// updateSelectionImage()



// createSelectionData
select.createSelectionData = function( x1, y1, x2, y2 )
{
	// swap coords if neccessary
	if(x1 > x2){
		var xx1 = x1;
		x1 = x2;
		x2 = xx1;
	}// swap x
	if(y1 > y2){
		var yy1 = y1;
		y1 = y2;
		y2 = yy1;
	}// swap y
	
	// define seleciton size
	var selectionWidth = x2 - x1 +1;
	var selectionHeight = y2 - y1 +1;
	
	// define array
	var newSelection = [];
	for( var xx=0; xx<selectionWidth; xx++)
	{
		newSelection[xx] = [];
		for( var yy=0; yy<selectionHeight; yy++)
		{
			newSelection[xx][yy] = select.getId( x1+xx, y1+yy );
		}// for:  selectionHeight
	}// for:  selectionWidth
	
	return newSelection;
}// createSelectionData()



// getId
select.getId = function( xx, yy )
{
	var thisLayer = _this.layer;
	return _this.mapData.layers[thisLayer][xx][yy];
}// getId()



// cancelSelection
select.cancelSelection = function()
{
	select.isPressed = false;
	// remove selection image
	delete select.selectionImage;
	_this.selectionImage.removeMovieClip();
	// delete selection data
	delete select._selection;
}// cancelSelection()



select.canSelect = function()
{
	var selectable = _this.selectable;
	if(_this.editable){
		var selectKey = Key.isDown(Key.SHIFT);
	}else{
		var selectKey = true;
	}
	
	return (selectable && selectKey);
}// canSelect()



// ---------------------------------------
// PROGRAM MOUSE

select.isPressed = false;



// press
_this.addEventListener( "onPress", select );
select.onPress = function()
{
	if(_this.selectable  &&  select.canSelect() )
	{// if:  "selectable" is ON
		select.isPressed = true;
		// remember start
		select.start = select.readPosition();
		select.end = select.readPosition();
		// place selection image
		if(_this.selectionImage == undefined)
			select.selectionImage = _this.attachMovie( "selection", "selectionImage", 2 );
		// update seleciton image
		select.updateSelectionImage(  select.start.x, select.start.y,  select.end.x, select.end.y  );
		
		// hide the selection image for 1 frame while it resizes
		select.selectionImage._visible = false;
		var showSelection = function(){
			select.selectionImage._visible = true;
		}
		setTimeout( showSelection, 34 );
	}// if:  "selectable" is ON
}// onPress()



// drag
_this.addEventListener( "onMouseMove", select );
select.onMouseMove = function()
{
	if(select.isPressed )
	{
		if( select.canSelect() )
		{
			// remember end
			select.end = select.readPosition();
			// update selection image
			select.updateSelectionImage(  select.start.x, select.start.y,  select.end.x, select.end.y  );
		}// if:  selection enabled
		else
		{// if:  selection disabled
			select.cancelSelection();
		}// if:  selection disabled
	}// if:  isPressed
}// onMouseMove()



// release
_this.addEventListener( "onRelease", select );
select.onRelease = function()
{
	if(select.isPressed )
	{
		if(select.canSelect() )
		{
			// remember end
			select.end = select.readPosition();
			// construct selection data
			select._selection = select.createSelectionData(  select.start.x, select.start.y,  select.end.x, select.end.y  );
			// event: selection
			_this.dispatchEvent({type:"onSelection"} );
			_this.onSelection();
			// release
			select.isPressed = false;
		}// if:  selection enabled
		else
		{// if:  selection disabled
			select.cancelSelection();
		}// if:  selection disabled
	}// if:  isPressed
}// onRelease()



// release
_this.addEventListener( "onReleaseOutside", select );
select.onReleaseOutside = select.onRelease;





// ______________________________________________________________________________
// INITIALIZE
_this.selection = select.initSelection;
_this.selectable = select.initSelectable;


// ______________________________________________________________________________
// UNLOAD
select.unload = function()
{
	_this.removeEventListener( "onPress", select );
	_this.removeEventListener( "onMouseMove", select );
	_this.removeEventListener( "onRelease", select );
	_this.removeEventListener( "onReleaseOutside", select );
	//
	_this.removeEventListener( "unload", select );
}// unload()
_this.addEventListener( "unload", select );